//=============================================================================
// NUUN_XPBattleCommand_KuroCustom.js
// ----------------------------------------------------------------------------
// (C)2023 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2023/04/19 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc   XP風パーティ、アクターコマンド くろあめ工房カスタム
 * @author くろあめ
 * @target MZ
 *
 * @param multiActionInfoSe
 * @text 複数回行動通知音
 * @desc 複数行動の一回目のコマンド入力時に演奏される効果音です。ファイル名未指定で演奏をスキップします。
 * @default
 * @type struct<SE>
 *
 * @help
 * NUUNさんXP風パーティ、アクターコマンドプラグインに
 * 複数回行動時に、全行動回数と今のコマンド入力が何回目の行動かを
 * 表示する機能を追加します。
 * 
 * このプラグインの利用には、NUUNさんのプラグイン本体と
 * MZ公式のDLCプラグイン「PluginCommonBase.js」が必要です
 * 「PluginCommonBase.js」は、RPGツクールMZのインストールフォルダ配下の
 * 以下のフォルダに格納されています。
 * dlc/BasicResources/plugins/official
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
 */
 
/*~struct~SE:
 *
 * @param name
 * @text SEファイル名
 * @desc SEのファイル名です。
 * @require 1
 * @dir audio/se/
 * @type file
 * @default
 *
 * @param volume
 * @text SEボリューム
 * @desc SEのボリュームです。
 * @type number
 * @default 90
 * @min 0
 * @max 100
 *
 * @param pitch
 * @text SEピッチ
 * @desc SEのピッチです。
 * @type number
 * @default 100
 * @min 50
 * @max 150
 *
 * @param pan
 * @text SEバランス
 * @desc SEの左右バランスです。
 * @type number
 * @default 0
 * @min -100
 * @max 100
 */

(function() {

'use strict';
const script = document.currentScript;
const param = PluginManagerEx.createParameter(script);

  // 再定義
  Window_ActorCommand.prototype.setCommandHeight = function() {
    if (this._actor && this._actor.numActions() > 1){
        const cols = this.maxItems();
        this.height = this.fittingHeight(cols) + 36;
    }
    else{
        const cols = this.maxItems();
        this.height = this.fittingHeight(cols);
    }
  };
  
  const _Window_ActorCommand_paint_mai = Window_ActorCommand.prototype.paint;
  Window_ActorCommand.prototype.paint = function() {
    _Window_ActorCommand_paint_mai.call(this);
    this.drawActionTimes();
  };
  

  Window_ActorCommand.prototype.drawActionTimes = function() {
      if(!this._actor || this._actor.numActions() <= 1){
          return;
      }
      if (this._actor._actionInputIndex < 1 &&param.multiActionInfoSe && param.multiActionInfoSe.name) {
          AudioManager.playSe(param.multiActionInfoSe);
      }
      const index = this.maxVisibleItems();
      const rect = this.itemLineRect(index-2);
      const align = this.itemTextAlign();
      this.changePaintOpacity(true);
      const dispStr = "【 " + this._actor.numActions() + "回行動" + (this._actor._actionInputIndex + 1) + "回目 】";
      this.changeTextColor(ColorManager.textColor(14));
      this.drawText_mai(dispStr, rect.x, rect.y, rect.width, align);
      this.resetFontSettings();
      this.resetTextColor();
  };
  
  Window_ActorCommand.prototype.drawText_mai = function(text, x, y, maxWidth, align) {
    this.contents.drawText(text, x, y, maxWidth, this.lineHeight(), align);
};

})();